#include <iostream>
#include <cmath>
using namespace std;

const double INF = 1e18;

int main() {
    int n;
    cin >> n;

    int x[2000], h[2000];
    for (int i = 0; i < n; i++) cin >> x[i];
    for (int i = 0; i < n; i++) cin >> h[i];

    int idx[2000];
    for (int i = 0; i < n; i++) idx[i] = i;

    for (int i = 0; i < n; i++) {
        for (int j = i + 1; j < n; j++) {
            if (x[j] < x[i]) {
                swap(x[i], x[j]);
                swap(h[i], h[j]);
                swap(idx[i], idx[j]);
            }
        }
    }

    double answer[2000];
    for (int i = 0; i < n; i++) answer[i] = INF;

    for (int i = 0; i < n; i++) {
        double best = INF;

        for (int j = 0; j < n; j++) {
            if (j == i) continue;
            if (h[j] >= h[i]) {
                double dx = x[j] - x[i];
                double dy = h[j] - h[i];
                best = min(best, sqrt(dx * dx + dy * dy));
            }
        }

        if (i > 0) {
            int dx = x[i] - x[i - 1];
            int minHeight = min(h[i], h[i - 1] - dx);

            if (minHeight >= h[i]) {
                best = min(best, (double)(x[i] - x[i - 1]));
            } else if (h[i - 1] >= h[i]) {
                int xIntersect = x[i - 1] + (h[i - 1] - h[i]);
                if (xIntersect >= x[i - 1] && xIntersect <= x[i]) {
                    best = min(best, (double)(x[i] - xIntersect));
                }
            }
        }

        if (i + 1 < n) {
            int dx = x[i + 1] - x[i];
            int minHeight = min(h[i], h[i + 1] - dx);

            if (minHeight >= h[i]) {
                best = min(best, (double)(x[i + 1] - x[i]));
            } else if (h[i + 1] >= h[i]) {
                int xIntersect = x[i + 1] - (h[i + 1] - h[i]);
                if (xIntersect >= x[i] && xIntersect <= x[i + 1]) {
                    best = min(best, (double)(xIntersect - x[i]));
                }
            }
        }

        if (best == INF) answer[idx[i]] = -1;
        else answer[idx[i]] = best;
    }

    for (int i = 0; i < n; i++) {
        if (answer[i] < 0) cout << -1 << "\n";
        else cout << (int)round(answer[i]) << "\n";
    }

    return 0;
}